function addCheckButton() {
  if (document.getElementById('yt-video-check-btn')) return;

  const buttonsRow = document.querySelector('#top-level-buttons-computed') || document.querySelector('#actions');
  if (!buttonsRow) return;

  if (!document.getElementById('vazirmatn-font')) {
    const fontLink = document.createElement('link');
    fontLink.id = 'vazirmatn-font';
    fontLink.rel = 'stylesheet';
    fontLink.href = 'https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css';
    document.head.appendChild(fontLink);
  }

  const btn = document.createElement('button');
  btn.id = 'yt-video-check-btn';
  btn.innerHTML = `
    <svg xmlns="http://www.w3.org/2000/svg" 
         width="20" height="20" viewBox="0 0 24 24" 
         fill="currentColor" style="margin-left:6px">
      <path d="M10 2a8 8 0 105.293 14.293l4.707 4.707 1.414-1.414-4.707-4.707A8 8 0 0010 2zm0 2a6 6 0 110 12 6 6 0 010-12z"/>
    </svg>
    بررسی ویدیو
  `;
  btn.style.cssText = `
    display: inline-flex !important;
    align-items: center !important;
    justify-content: center !important;
    gap: 6px !important;
    padding: 6px 12px !important;
    margin-left: 8px !important;
    border: none !important;
    border-radius: 18px !important;
    background: #f2f2f2 !important;
    color: #0f0f0f !important;
    font-family: 'Vazirmatn', sans-serif !important;
    font-size: 14px !important;
    cursor: pointer !important;
    transition: background 0.2s ease !important;
  `;

  btn.onmouseover = () => {
    btn.style.background = "#e5e5e5";
  };
  btn.onmouseout = () => {
    btn.style.background = "#f2f2f2";
  };

  btn.onclick = function () {
    let videoId = null;
    const url = window.location.href;

    const patterns = [
      /v=([a-zA-Z0-9_-]{11})/,
      /youtu\.be\/([a-zA-Z0-9_-]{11})/,
      /shorts\/([a-zA-Z0-9_-]{11})/,
      /embed\/([a-zA-Z0-9_-]{11})/
    ];

    for (const pattern of patterns) {
      const match = url.match(pattern);
      if (match && match[1]) {
        videoId = match[1];
        break;
      }
    }

    if (!videoId) {
      alert('شناسه ویدیو یافت نشد!');
      return;
    }

    const videoUrl = `https://youtu.be/${videoId}`;
    const wpUrl = `https://gotube.ir/?video=${encodeURIComponent(videoUrl)}`;
    window.open(wpUrl, '_blank');
  };

  buttonsRow.appendChild(btn);
}

setInterval(addCheckButton, 2000);
